Triggers = {}

include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/end_trigger")
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/kill_watcher")

Triggers["center_point"] = 
{
	active = false, 
	effect_radius = 20, 
	position = { x = 123.87, y = 131.12, z = 5, f = 1.0}, 
	priority = 1.0, 
	think = "tf_center_point", 
	type = "quest", 
}

Triggers["army_set"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_army_set", 
	type = "quest", 
}

Triggers["campaign"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=-51, x=-40.8, z=4.8, f=1 }, 
	priority = 1, 
	think = "tf_campaign", 
	type = "quest", 
}

Triggers["corp_set"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_corp_set", 
	type = "quest", 
}

Triggers["on_start"] = 
{
	active = true, 
	effect_radius = 9, 
	position = { y=184.2, x=17.7, z=17.5, f=1 }, 
	priority = 1, 
	think = "tf_on_start", 
	type = "quest", 
}

Triggers["patrol_0"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "circle", 
	point_count = 26, 
	point_radius = 0.5, 
	position = { x = 77.1, y = 112.0, z = 7.9, f = 1.0}, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "none", 
	wait_time = 2, 
	patrol_points = {{ x=77.0867, y=112.029, z=7.85203},{ x=58.101, y=123.774, z=8.8252},{ x=46.5969, y=131.462, z=11.2242},{ x=41.154, y=144.705, z=12.1706},{ x=44.0779, y=148.757, z=12.0057},{ x=55.0163, y=155.795, z=11.8506},{ x=65.9293, y=157.667, z=13.8088},{ x=81.1882, y=152.447, z=16.6573},{ x=105.849, y=151.986, z=18.4271},{ x=115.262, y=155.306, z=18.4757},{ x=131.355, y=150.942, z=20.189},{ x=147.109, y=144.917, z=21.3298},{ x=159.875, y=141.177, z=22.4073},{ x=171.093, y=142.328, z=24.2498},{ x=180.284, y=151.276, z=27.9701},{ x=177.479, y=162.704, z=28.5797},{ x=171.028, y=179.403, z=27.7738},{ x=160.336, y=187.643, z=26.3649},{ x=147.722, y=196.03, z=25.3575},{ x=121.67, y=202.866, z=24.8219},{ x=109.435, y=199.649, z=26.389},{ x=99.3167, y=196.49, z=26.5545},{ x=83.5109, y=193.916, z=26.6696},{ x=42.7728, y=189.398, z=20.7194},{ x=31.2531, y=189.223, z=18.7605},{ x=14.1996, y=181.785, z=17.4645} }
}

Triggers["patrol_1"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "circle", 
	point_count = 12, 
	point_radius = 0.5, 
	position = { x = 167.9, y = 60.3, z = 4.8, f = 1.0}, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "none", 
	wait_time = 2, 
	patrol_points = {{ x=167.864, y=60.3308, z=4.76243},{ x=167.245, y=72.6999, z=5.54453},{ x=167.09, y=75.6492, z=5.54453},{ x=161.566, y=79.3892, z=5.54453},{ x=156.989, y=72.3332, z=5.54453},{ x=143.793, y=71.4598, z=6.90553},{ x=139.052, y=72.0385, z=6.90553},{ x=118.178, y=75.3378, z=6.90553},{ x=104.772, y=71.9223, z=6.90553},{ x=94.317, y=74.9634, z=6.90553},{ x=93.2925, y=81.1728, z=6.90553},{ x=92.3436, y=107.415, z=7.91542} }
}

Triggers["relations_vs_army"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_relations_vs_army", 
	type = "quest", 
}

trigger_functions =
{
tf_army_set = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if(isValid(Humans["army_15"])) then
			Humans["army_15"].patrol_routine = "patrol_0"
		end
		if(isValid(Humans["army_16"])) then
			Humans["army_16"].patrol_routine = "patrol_0"
		end
		if(isValid(Humans["army_17"])) then
			Humans["army_17"].patrol_routine = "patrol_0"
		end
		if(isValid(Humans["army_6"])) then
			Humans["army_6"].patrol_routine = "patrol_1"
		end
		if(isValid(Humans["army_18"])) then
			Humans["army_18"].patrol_routine = "patrol_1"
		end
		trigger.active = false
	end
end,
tf_campaign = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
		if ARMY == Sectors.port.owner then
			Triggers["army_set"].active = true
		end	
		if CORP == Sectors.port.owner then
			Triggers["corp_set"].active = true
		end	
	end
end,
tf_corp_set = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
	end
end,
tf_on_start = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if(trigger_utility.isPlayerPresent(trigger_id,"mercs") ) then			
			Triggers["campaign"].active = true
			trigger.active = false
		end
	end
end,
tf_relations_vs_army = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
			changeLocalRelations(ENEMY, "army")		
			
--			changeLocalRelations(ALLY, "army")		
		trigger.active = false
	end
end,
--
-- end trigger
--
tf_end_trigger = CommonTriggers.end_trigger,
--
-- kill watcher trigger
--
tf_kill_watcher = CommonTriggers.kill_watcher,
--
-- honey point for bees
--
tf_center_point = CommonTriggers.center_point,
}
